__author__ = 'Konstantin_Brand', 'Gerald Schuller'

from pylab import *


def DSTo(N):
    ''' Calculate the DSTo (odd DST with size NxN)
    Args:
        N: (int)
    Return:
        DSTo: (ndarray)
    '''
    DSTo = zeros((N, N))
    for n in range(0, N):
        for k in range(0, N):
            DSTo[n, k] = sin(pi/N*(k+0.5)*(n+0.5))
    
    return DSTo


def DCTo(N):
    ''' Calculate the DCTo (odd DCT with size NxN)
    Args:
        N: (int)
    Return:
        DCTo: (ndarray)
    '''
    DCTo = zeros((N, N))
    for n in range(N):
        for k in range(N):
            DCTo[n, k] = cos(pi/N*(k+0.5)*(n+0.5))
    
    return DCTo


def optimfuncDSTDCTL1(x):
    #function to minimize, dim. of x is 32.
    #Example of matching pursiut, overcomplete transform with DCT and DST and L1 norm.
    #Args: x: (ndarray)
    #Return: optimfuncDSTDCTL1 : (ndarray) 

    # Overcomplete transform:
    t = hstack((DCTo(16), DSTo(16)))
    # Signal Example:
    s = cos(pi/16*(arange(16))*12.5)
    # Lagrange optimization:
    return  sum((s-dot(t, x))**2)+sum(abs(x))
     

def optimfuncDSTDCTL1randsamp(x):
    ''' function to minimize, dim. of x is 32
    x is the sparse vector of unknown (DCT and DST) doefficients.
    Example of matching pursiut and random sampling, overcomplete transform with DCT and DST and L1 (abs) norm.

    Args:
        x: (ndarray)
    Return:
         optimfuncDSTDCTL1randsamp: (ndarray)
    '''
    # Overcomplete transform:
    t = hstack((DCTo(16), DSTo(16)))

    # Signal Example:
    s = cos(pi/16*(arange(16))*12.5)

    # random sampling with a constant pattern:
    seed([1, 2, 3])
    r = rand(16, 1)
    # only a fraction of 0.25 is randomly sampled, hence below Nyquist!:
    randpat = r < 0.6
    randpat.astype(int)

    # Lagrange optimization, with distance measure only for random samples:
    optimfuncDSTDCTL1randsamp = sum(((s-dot(t, x))*randpat)**2)+sum(abs(x))

    return optimfuncDSTDCTL1randsamp

def optimfuncDSTDCTL1randcomb(x):
    ''' function to minimize, dim. of x is 32
    x is the sparse vector of unknown (DCT and DST) doefficients.
    Example of matching pursiut and random sampling, overcomplete transform with DCT and DST and L1 (abs) norm.

    Args:
        x: (ndarray)
    Return:
         optimfuncDSTDCTL1randcomb: (ndarray)
    '''
    # Overcomplete transform:
    t = hstack((DCTo(16), DSTo(16)))

    # Signal Example:
    s = cos(pi/16*(arange(16))*12.5)

    # random sampling with a constant pattern:
    seed([1, 2, 3])

    # random measurement matrix PHI, with 5 measurements per non-zero coefficient (2 coeff)
    PHI = rand(10, 16)

    # Lagrange optimization, with distance measure only for random samples:
    optimfuncDSTDCTL1randcomb = sum(((PHI*s)-(PHI*dot(t, x)))**2)+sum(abs(x))

    return optimfuncDSTDCTL1randcomb


def optimfuncL1randcomb(x):
    ''' function to minimize, dim. of x is 32
    x is the sparse vector of unknowns, in this case directly samples.
    Example of matching pursiut and random combinations, L1 (abs) norm.

    Args:
        x: (ndarray)
    Return:
         optimfuncDSTDCTL1randcomb: (ndarray)
    '''

    # Signal Example:
    s = zeros(1, 32)
    s[3] = 2
    s[23] = 1

    # Initialize random generator:
    seed([1, 2, 3])
    # random measurement matrix PHI, with 5 measurements per non-zero coefficient (2 coeff):
    PHI = rand(10,32);

    # Lagrange optimization, with distance measure only for random samples:
    optimfuncL1randcomb = sum(((PHI*s)-(PHI*x))**2)+sum(abs(x))

    return optimfuncL1randcomb


def fminuncOptFun2(x):
    ''' function to minimize, dim. of x is 16

    Args:
        x: (ndarray)
    Return:
         fminuncOptFun2: (ndarray)
    '''
    # sample = array([0, 0, 0, 0 ,0 ,1 ,1 ,0 ,1 ,0 ,0 ,1, 0, 0, 1 ,0])
    sample = array([0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 1])

    s=cos(pi/16*(arange(15)+0.5)*3.5)
    ssmpl = dot(s, sample)

    x1 = dot(x, ((1-sample)+ssmpl))  # original samples plus new to be optimized samples

    t = DCTo(16)

    ts = x1*t

    fminuncOptFun2 = sum(abs(ts)) #value to be optimized (abs sum of DCT transform coeff.)

    return fminuncOptFun2
